<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms\Business\Insights;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class SuccessRateContext extends InstanceContext {
    /**
     * Initialize the SuccessRateContext
     *
     * @param \Twilio\Version $version Version that contains the resource
     * @param string $businessSid Business Sid.
     * @return \Twilio\Rest\Preview\TrustedComms\Business\Insights\SuccessRateContext
     */
    public function __construct(Version $version, $businessSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('businessSid' => $businessSid, );

        $this->uri = '/Businesses/' . \rawurlencode($businessSid) . '/Insights/SuccessRate';
    }

    /**
     * Fetch a SuccessRateInstance
     *
     * @param array|Options $options Optional Arguments
     * @return SuccessRateInstance Fetched SuccessRateInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch($options = array()) {
        $options = new Values($options);

        $params = Values::of(array(
            'BrandSid' => $options['brandSid'],
            'BrandedChannelSid' => $options['brandedChannelSid'],
            'PhoneNumberSid' => $options['phoneNumberSid'],
            'Country' => $options['country'],
            'Start' => Serialize::iso8601DateTime($options['start']),
            'End' => Serialize::iso8601DateTime($options['end']),
            'Interval' => $options['interval'],
        ));

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new SuccessRateInstance($this->version, $payload, $this->solution['businessSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.TrustedComms.SuccessRateContext ' . \implode(' ', $context) . ']';
    }
}